function V = SE_NWLS(Y,V,S,idx_V,idx_S,sd_V,sd_delta,sd_PQ,V_0,n_max,tol)
% V = SE_NWLS(Y,V,S,idx_V,idx_S,sd_V,sd_delta,sd_PQ,V_0,_max,tol)
%
% INPUT
% - Y           Nodal admittance matrix
% - V           Measured voltage phasors.
% - S           Measured active/reactive powers.
% - idx_V       Locations of voltage phasor measurements.
% - idx_S       Locations of power measurements.
% - sd_V        Standard deviation of voltage measurements.
% - sd_delta    Standard deviation of angle measurements.
% - sd_PQ       Standard deviation of power measurements.
% - V_0         Initial point.
% - n_max       Maxinum number of iteration.
% - tol         Convergence tolerance.
%
% OUTPUT
% - V           Estimated voltage phasors.

z = [abs(V);angle(V);real(S);imag(S)];
R = R_NWLS(idx_V,idx_S,sd_V,sd_delta,sd_PQ);

for k=1:n_max
    
    % Initial value
    if(k==1)
        V = V_0;
    end
    
    % ******************************
    % ! Write your own code here !
    % ******************************
    
    x = [abs(V);angle(V)];
    
    [h,dh_dx] = h_NWLS(Y,V,idx_V,idx_S);
    
    dx = [];
    x = x + dx;
    
    % ******************************
    
    % Convergence criterion
    if(max(abs(dx))<tol)
        break;
    end
    
    V = x(1:end/2) .* exp(1i*x((end/2+1):end));
end

end